;________________________________________________________________________
;
;                            S A M P L E . A S M  
;________________________________________________________________________
;
; Sample Packet Sending   by Byon Garrabrant  N6BG  byon@mail.com  Feb 99
;________________________________________________________________________
;
;   This software is  available only for non-commercial  amateur radio 
;   or educational  applications.   ALL  other  uses  are  prohibited.  
;   This  software may  be  modified  only  if the  resulting code  be 
;   made available  publicly  and the  original  author given  credit.  
;   Contact the author or TAPR for information on commercial licenses. 
;   (c) Copyright 1999,  Byon Garrabrant,  N6BG.  All rights reserved. 
;________________________________________________________________________

	LIST	P=PIC16F84
	include	"P16F84.INC"
	__CONFIG _HS_OSC & _CP_OFF & _PWRTE_ON & _WDT_OFF
;________________________________________________________________________

	cblock	H'0C'			; variables
		index
		delay1
		delay2
		delay3
	endc
;________________________________________________________________________

	ORG	0			; start code
	goto	main
;________________________________________________________________________

	include	"PACKET.ASM"		; include packet sending code
;________________________________________________________________________

Get_Message_Char
	addwf	PCL, F	
	dt	"Hi", H'0A'
	dt	0
;________________________________________________________________________

delay
	movlw	D'20'
	movwf	delay3
delay_loop				; delay about 2 seconds
	decfsz	delay1, F	
	 goto	delay_loop
	decfsz	delay2, F	
	 goto	delay_loop
	decfsz	delay3, F	
	 goto	delay_loop
	return 
;________________________________________________________________________

main
	call	Packet_Init		; setup the packet system
	
mainLoop
	call	Packet_Start		; start sending a packet
	
	clrf	index
message_loop
	movfw	index
	call	Get_Message_Char	; send the message
	iorlw	0
	skpnz
	 goto	message_done		; until we get a zero
	call	Packet_Send
	incf	index, F		; bump to next char
	goto	message_loop
	
message_done		
	call	Packet_End		; complete the packet
	
	call	delay	 
	
	goto	mainLoop		; loop back again

	END
;________________________________________________________________________

